angular.module('handleSecondWindow').controller('fieldContentCtrl', function ($scope) {

    /********************************
     ************ Fields *************
     ********************************/
    $scope.fields = {};
    $scope.fields.fieldOrder = fieldOrder;
    $scope.fields.symbols = symbolProperties;
    $scope.fields.currentField = {};
    $scope.fields.currentField.image = "images/symbols/_universal.svg";
    $scope.fields.currentField.topText = "";
    $scope.fields.currentField.bottomText = "";
    $scope.fields.currentField.commentField = "";
    $scope.fields.currentField.id = undefined;
    $scope.fields.currentField.fieldTextTop = "";
    $scope.fields.currentField.fieldTextBottom = "";
    $scope.fields.currentField.fieldComment = "";
    $scope.fields.currentField.fieldTitle = "";

    $('#myAffix').affix();

    var value = windowManager.sharedData.fetch('loadSelectedSymbol');
    if (value) {
        $scope.fields.currentField.image = value.currentField.image;
        $scope.fields.currentField.fieldTextTop = value.currentField.fieldTextTop;
        $scope.fields.currentField.fieldTextBottom = value.currentField.fieldTextBottom;
        $scope.fields.currentField.fieldComment = value.currentField.fieldComment;
        windowManager.sharedData.set('loadSelectedSymbol', null);
        $('#navFieldContent').addClass('active');
    }

    $scope.fields.filterSymbols = function (string) {
        $scope.filter_symbols = {name: string}
    };

    /**
     * @desc changes symbol of currentField in tz
     * @param name: name of the image
     * @param title: title of the image
     * @param description: tooltip text
     **/
    $scope.fields.selectSymbol = function (name, title, description) {
        $scope.fields.currentField.fieldTitle = description;
        $scope.fields.currentField.fieldTextTop = title;
        $scope.fields.currentField.image = "images/symbols/" + name + ".svg";
    };

    $scope.fields.submit = function () {
        var tmpObj = {
            imageSrc: $scope.fields.currentField.image,
            fieldTop: document.getElementById('fieldTextTop').value,
            fieldBottom: document.getElementById('fieldTextBottom').value,
            fieldComment: document.getElementById('fieldComment').value,
            fieldTitle: $scope.fields.currentField.fieldTitle
        };
        windowManager.bridge.emit('submitField', tmpObj);
    };

    $scope.fields.delete = function () {
        $scope.fields.currentField.image = "images/symbols/_universal.svg";
        $scope.fields.currentField.fieldTextTop = '';
        $scope.fields.currentField.fieldTextBottom = '';
        $scope.fields.currentField.fieldComment = '';
        $scope.fields.currentField.fieldTitle = '';
        windowManager.bridge.emit('delete');
    };
});